/*
 * Decompiled with CFR 0.152.
 */
package scene.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.text.Text;
import javafx.util.Callback;
import shared.Translation;

public class LegendController
implements Initializable {
    @FXML
    private TableView<Translation> legendTable;

    private void resetTable() {
        this.legendTable.setEditable(true);
        this.legendTable.getColumns().clear();
        this.legendTable.getItems().clear();
    }

    public void fillLegend(ObservableList<Translation> items) {
        this.resetTable();
        TableColumn column1 = new TableColumn("Tag");
        column1.setCellValueFactory((Callback)new PropertyValueFactory("nodeTag"));
        TableColumn column2 = new TableColumn("Fuzzy Concept");
        column2.setCellValueFactory((Callback)new PropertyValueFactory("nodeName"));
        this.legendTable.getColumns().addAll((Object[])new TableColumn[]{column1, column2});
        this.legendTable.setItems(items);
        this.autoResizeColumns(this.legendTable);
    }

    public void autoResizeColumns(TableView<?> table) {
        table.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        table.getColumns().stream().forEach(column -> {
            Text t = new Text(column.getText());
            double max = t.getLayoutBounds().getWidth();
            for (int i = 0; i < table.getItems().size(); ++i) {
                double calcwidth;
                if (column.getCellData(i) == null || !((calcwidth = (t = new Text(column.getCellData(i).toString())).getLayoutBounds().getWidth()) > max)) continue;
                max = calcwidth;
            }
            column.setPrefWidth(max + 10.0);
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        System.out.println("Initialize Legend Controller");
    }
}

